<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('service_area_id');
			$table->integer('customer_id');
			$table->integer('number')->unique();
			$table->enum('type', array('new', 'return', 'cancellation'));
			$table->date('dropoff_date')->nullable();
			$table->integer('dropoff_address')->nullable();
			$table->integer('dropoff_timeslot')->nullable();
			$table->date('pickup_date')->nullable();
			$table->integer('pickup_address')->nullable();
			$table->integer('pickup_timeslot')->nullable();
			$table->enum('cancel_reason', array('customer', 'fraud', 'other'));
			$table->datetime('cancelled_at')->nullable();
			$table->enum('financial_status', array('pending', 'complete'))->nullable();
			$table->string('source', 200);
			$table->text('notes')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}