<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerStorablesTable extends Migration {

	public function up()
	{
		Schema::create('customer_storables', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('warehouse_id');
			$table->integer('customer_id');
			$table->integer('storable_id');
			$table->integer('bin_id')->nullable();
			$table->float('price');
			$table->enum('status', array('in_transit_to_warehouse', 'awaiting_storage_at_warehouse', 'stored', 'awaiting_transit_at_warehouse', 'in_transit_to_customer', 'with_customer'));
			$table->text('notes')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('customer_storables');
	}
}