<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceItemsTable extends Migration {

	public function up()
	{
		Schema::create('invoice_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('invoice_id');
			$table->integer('customer_storable_id')->nullable();
			$table->date('billing_cycle_start');
			$table->date('billing_cycle_end');
			$table->integer('billing_cycle_count');
			$table->float('price');
			$table->float('total');
			$table->boolean('is_prorated');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('invoice_items');
	}
}