<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWarehousesTable extends Migration {

	public function up()
	{
		Schema::create('warehouses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('service_area_id');
			$table->string('name', 200);
			$table->string('internal_name', 200)->nullable();
			$table->string('address_1', 200);
			$table->string('address_2', 200);
			$table->string('city', 200);
			$table->string('state', 200);
			$table->string('postal_code', 20);
			$table->integer('country_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('warehouses');
	}
}