<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('service_area_id');
			$table->string('billing_provider_customer_id', 100)->nullable();
			$table->date('billing_started_at')->nullable();
			$table->integer('billing_day')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}