<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountCodesTable extends Migration {

	public function up()
	{
		Schema::create('discount_codes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('service_area_id');
			$table->string('code', 32)->unique();
			$table->enum('type', array('percent', 'fixed'));
			$table->boolean('is_recurring')->default(false);
			$table->float('amount');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('discount_codes');
	}
}