<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNeighborhoodsTable extends Migration {

	public function up()
	{
		Schema::create('neighborhoods', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 200);
			$table->integer('service_area_id');
			$table->decimal('sales_tax_rate')->nullable();
			$table->boolean('taxable_shipping')->nullable()->default(false);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('neighborhoods');
	}
}