<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationTemplatesTable extends Migration {

	public function up()
	{
		Schema::create('notification_templates', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->string('slug', 100)->unique();
			$table->text('email')->nullable();
			$table->string('sms', 200);
			$table->string('push', 100)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notification_templates');
	}
}