<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStorablesTable extends Migration {

	public function up()
	{
		Schema::create('storables', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('service_area_id');
			$table->boolean('is_bin')->default(false);
			$table->string('name', 200);
			$table->text('description');
			$table->decimal('external_length')->nullable();
			$table->decimal('external_width')->nullable();
			$table->decimal('external_height')->nullable();
			$table->decimal('internal_length')->nullable();
			$table->decimal('internal_width')->nullable();
			$table->decimal('internal_height')->nullable();
			$table->float('price');
			$table->boolean('is_taxable')->default(true);
			$table->integer('prepaid_month_count')->nullable();
			$table->enum('storage_method', array('warehouse_rack', 'bike_rack', 'other'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('storables');
	}
}