<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMembersTable extends Migration {

	public function up()
	{
		Schema::create('members', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('job_title');
			$table->timestamps();
			$table->softDeletes();
			$table->string('email');
			$table->string('password');
			$table->string('national_id')->unique();
			$table->timestamp('joind_at')->nullable();
			$table->date('birthdate')->nullable();
			$table->text('qualifications')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('members');
	}
}