<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Member extends Eloquent {

	protected $table = 'members';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->hasMany('Attachment');
	}

	public function user()
	{
		return $this->hasOne('Job');
	}

	public function services()
	{
		return $this->hasMany('Service');
	}

}