<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_plans', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('owners')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_plans', function(Blueprint $table) {
			$table->foreign('installment_duration_id')->references('id')->on('installment_durations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_plans', function(Blueprint $table) {
			$table->foreign('payment_cycle_id')->references('id')->on('payment_cycles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('owners', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('owners')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('payment_plan_id')->references('id')->on('payment_plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('installmenplanpayments', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contracts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('installmenplanpayments', function(Blueprint $table) {
			$table->foreign('payment_type_id')->references('id')->on('payment_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('installmenplanpayments', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('payment_methods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_owner_id_foreign');
		});
		Schema::table('payment_plans', function(Blueprint $table) {
			$table->dropForeign('payment_plans_owner_id_foreign');
		});
		Schema::table('payment_plans', function(Blueprint $table) {
			$table->dropForeign('payment_plans_installment_duration_id_foreign');
		});
		Schema::table('payment_plans', function(Blueprint $table) {
			$table->dropForeign('payment_plans_payment_cycle_id_foreign');
		});
		Schema::table('owners', function(Blueprint $table) {
			$table->dropForeign('owners_user_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_unit_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_owner_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_payment_plan_id_foreign');
		});
		Schema::table('installmenplanpayments', function(Blueprint $table) {
			$table->dropForeign('installmenplanpayments_contract_id_foreign');
		});
		Schema::table('installmenplanpayments', function(Blueprint $table) {
			$table->dropForeign('installmenplanpayments_payment_type_id_foreign');
		});
		Schema::table('installmenplanpayments', function(Blueprint $table) {
			$table->dropForeign('installmenplanpayments_payment_method_id_foreign');
		});
	}
}