<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('_id')->primary();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email')->unique();
			$table->string('password');
			$table->enum('login_type', array('general', 'social'));
			$table->enum('role', array('admin', 'user', 'manager'));
			$table->string('provider_id');
			$table->string('city');
			$table->string('zip');
			$table->string('country');
			$table->string('adress');
			$table->string('display_picture');
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}