<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTapsTable extends Migration {

	public function up()
	{
		Schema::create('Taps', function(Blueprint $table) {
			$table->increments('_id');
			$table->timestamps();
			$table->string('user_id');
			$table->string('nfc_id');
			$table->string('location');
			$table->enum('type', array('contact', 'general', 'product', 'link', 'event'));
			$table->string('is_favourite');
		});
	}

	public function down()
	{
		Schema::drop('Taps');
	}
}