<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StaffMember extends Model 
{

    protected $table = 'staff_members';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->hasOne('User');
    }

    public function functionTitles()
    {
        return $this->hasMany('FunctionTitle');
    }

    public function schedules()
    {
        return $this->morphMany('Schedule');
    }

}