<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pupil extends Model 
{

    protected $table = 'pupils';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->belongsToMany('User');
    }

    public function registered_courses()
    {
        return $this->hasMany('CoursePupilPivot');
    }

}