<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ArticuloDestino extends Eloquent {

	protected $table = 'articulo_destino';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function destino()
	{
		return $this->belongsTo('App\Models\Destino');
	}

	public function articulo()
	{
		return $this->belongsTo('App\Models\Articulo');
	}

	public function reponsable()
	{
		return $this->hasOne('App\Models\Responsable');
	}

}