<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Project extends Model 
{

    protected $table = 'projects';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function task()
    {
        return $this->hasMany('Task');
    }

    public function rapport()
    {
        return $this->hasMany('Rapport');
    }

    public function statu()
    {
        return $this->belongsToMany('Statu');
    }

    public function client()
    {
        return $this->belongsTo('App\Client');
    }

}