<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('prenom');
			$table->date('date_nais');
			$table->string('adress');
			$table->string('tel');
			$table->string('email')->unique();
			$table->string('password');
			$table->string('fonction');
			$table->integer('site_id');
			$table->integer('taux_occup');
			$table->string('avatar')->default('default.jpg');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}