<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function properties()
    {
        return $this->belongsToMany('App\Property');
    }

    public function favorites()
    {
        return $this->belongsToMany('App\Favorite');
    }

    public function package()
    {
        return $this->hasOne('App\User', 'id', 'package_id');
    }

}