<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('package_id')->nullable()->index();
			$table->string('first_name', 191)->nullable();
			$table->string('last_name', 191)->nullable();
			$table->string('email', 191);
			$table->string('password', 191);
			$table->string('phone', 20)->nullable();
			$table->boolean('is_whatsapp')->nullable()->default(0);
			$table->string('company_name', 191)->nullable();
			$table->string('profile_pic', 191)->nullable();
			$table->string('stripe_id', 191)->nullable();
			$table->string('card_brand', 191)->nullable();
			$table->string('card_last_four', 191)->nullable();
			$table->boolean('is_professional')->nullable()->default(0);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}