<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Employee', function(Blueprint $table) {
			$table->foreign('Dept_Id')->references('id')->on('Departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('attendanceReport', function(Blueprint $table) {
			$table->foreign('Employee_Id')->references('id')->on('Employee')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Employee', function(Blueprint $table) {
			$table->dropForeign('Employee_Dept_Id_foreign');
		});
		Schema::table('attendanceReport', function(Blueprint $table) {
			$table->dropForeign('attendanceReport_Employee_Id_foreign');
		});
	}
}