<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Athlete extends Eloquent {

	protected $table = 'athletes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('firstname', 'lastname', 'date_of_birth', 'status', 'image', 'slug', 'trophy_id', 'division_id', 'active');

	public function trainers()
	{
		return $this->belongsToMany('App\Models\Trainer');
	}

	public function disciplines()
	{
		return $this->belongsToMany('App\Models\Discipline');
	}

	public function divisions()
	{
		return $this->belongsTo('App\Models\Division');
	}

	public function trophies()
	{
		return $this->hasMany('App\Models\Trophy');
	}

	public function trainings()
	{
		return $this->belongsToMany('App\Models\Training');
	}

}