<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Trophy extends Eloquent {

	protected $table = 'trophies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('year', 'name');

	public function athletes()
	{
		return $this->belongsTo('App\Models\Athlete');
	}

}