<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Discipline extends Eloquent {

	protected $table = 'disciplines';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'slug', 'gender');

	public function athletes()
	{
		return $this->belongsToMany('App\Models\Athlete');
	}

	public function trainers()
	{
		return $this->belongsToMany('App\Models\Trainer');
	}

}