<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTable extends Migration {

	public function up()
	{
		Schema::create('news', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 255);
			$table->text('content');
			$table->string('slug', 255)->unique();
			$table->integer('user_id')->unsigned()->index()->default('1');
		});
	}

	public function down()
	{
		Schema::drop('news');
	}
}