<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class News extends Eloquent {

	protected $table = 'news';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'content', 'slug', 'user_id');

	public function user()
	{
		return $this->belongsTo('App\User');
	}

}