<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Subcategory extends Eloquent {

	protected $table = 'subcategories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('category_id', 'name');

	public function category()
	{
		return $this->belongsTo('App\Category');
	}

	public function products()
	{
		return $this->hasMany('App\Product');
	}

}