<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('level', 'password', 'email', 'first_name', 'last_name');
	protected $hidden = array('password');

	public function products()
	{
		return $this->hasMany('Product');
	}

	public function news()
	{
		return $this->hasMany('App\News');
	}

}