<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerTable extends Migration {

	public function up()
	{
		Schema::create('Customer', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 40);
			$table->string('email', 30)->unique();
			$table->string('company', 30);
			$table->string('phone', 20);
		});
	}

	public function down()
	{
		Schema::drop('Customer');
	}
}