<?php

namespace request;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Request extends Model 
{

    protected $table = 'Request';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function customer()
    {
        return $this->hasOne('Customer', 'customer');
    }

    public function department()
    {
        return $this->hasOne('Department', 'department');
    }

}