<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GroupPermission extends Model 
{

    protected $table = 'group_permissions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function group()
    {
        return $this->belongsTo('App\Groups', 'id');
    }

    public function permission()
    {
        return $this->belongsTo('App\Permissions', 'id');
    }

}