<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserPermissions extends Model 
{

    protected $table = 'user_permissions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('App\Users', 'id');
    }

    public function permission()
    {
        return $this->belongsTo('App\Permissions', 'id');
    }

}