<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_metas', function(Blueprint $table) {
			$table->foreign('userid')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('moduleid')->references('id')->on('modules')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('group_permissions', function(Blueprint $table) {
			$table->foreign('groupid')->references('id')->on('groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('group_permissions', function(Blueprint $table) {
			$table->foreign('permissionid')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_permissions', function(Blueprint $table) {
			$table->foreign('userid')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_permissions', function(Blueprint $table) {
			$table->foreign('permissionid')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_metas', function(Blueprint $table) {
			$table->dropForeign('user_metas_userid_foreign');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_moduleid_foreign');
		});
		Schema::table('group_permissions', function(Blueprint $table) {
			$table->dropForeign('group_permissions_groupid_foreign');
		});
		Schema::table('group_permissions', function(Blueprint $table) {
			$table->dropForeign('group_permissions_permissionid_foreign');
		});
		Schema::table('user_permissions', function(Blueprint $table) {
			$table->dropForeign('user_permissions_userid_foreign');
		});
		Schema::table('user_permissions', function(Blueprint $table) {
			$table->dropForeign('user_permissions_permissionid_foreign');
		});
	}
}