<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('answer_customer', function(Blueprint $table) {
			$table->foreign('answer_id')->references('id')->on('answers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answer_customer', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answer_customer', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answer_question', function(Blueprint $table) {
			$table->foreign('answer_id')->references('id')->on('answers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answer_question', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('answer_customer', function(Blueprint $table) {
			$table->dropForeign('answer_customer_answer_id_foreign');
		});
		Schema::table('answer_customer', function(Blueprint $table) {
			$table->dropForeign('answer_customer_customer_id_foreign');
		});
		Schema::table('answer_customer', function(Blueprint $table) {
			$table->dropForeign('answer_customer_question_id_foreign');
		});
		Schema::table('answer_question', function(Blueprint $table) {
			$table->dropForeign('answer_question_answer_id_foreign');
		});
		Schema::table('answer_question', function(Blueprint $table) {
			$table->dropForeign('answer_question_question_id_foreign');
		});
	}
}