<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVestingsTable extends Migration {

	public function up()
	{
		Schema::create('vestings', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('employee_id')->unsigned();
			$table->date('start_period');
			$table->string('date_limit');
			$table->bigInteger('vacations_option_id')->unsigned();
			$table->boolean('vacations_enjoyed');
			$table->boolean('sell_days');
			$table->boolean('13th_advance');
			$table->longText('justification');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('vestings');
	}
}