<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVacationsTable extends Migration {

	public function up()
	{
		Schema::create('vacations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('vesting_id')->unsigned();
			$table->date('start_date');
			$table->date('end_date');
			$table->boolean('manager_approval');
			$table->timestamps();
			$table->integer('days');
			$table->softDeletes();
			$table->date('return_day');
		});
	}

	public function down()
	{
		Schema::drop('vacations');
	}
}