<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->string('project_name');
			$table->string('project_client')->nullable();
			$table->text('description')->nullable();
			$table->text('note')->nullable();
			$table->date('start_date')->nullable();
			$table->date('end_date')->nullable();
			$table->string('status', 20);
			$table->datetime('completed_on')->nullable();
			$table->string('mark_completed_by')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}