<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTimesheetsTable extends Migration {

	public function up()
	{
		Schema::create('timesheets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title')->nullable();
			$table->string('task_id')->nullable();
			$table->date('date')->nullable();
			$table->integer('total_time_spent')->nullable();
			$table->integer('total_hours')->nullable();
			$table->integer('total_minutes')->nullable();
			$table->datetime('start_time')->nullable();
			$table->datetime('end_time')->nullable();
			$table->text('details')->nullable();
			$table->text('remarks')->nullable();
			$table->integer('user_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('timesheets');
	}
}