<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('status')->nullable();
			$table->string('note');
			$table->integer('project_id')->unsigned()->nullable();
			$table->datetime('start_date')->nullable();
			$table->datetime('end_date')->nullable();
			$table->datetime('completed_on')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}