<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->datetime('start_date_time');
			$table->datetime('end_date_time');
			$table->bigInteger('location_id')->unsigned();
			$table->string('name', 100);
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}