<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRacesTable extends Migration {

	public function up()
	{
		Schema::create('races', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name', 100);
			$table->date('date');
			$table->time('start_time');
			$table->bigInteger('track_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('races');
	}
}