<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Driver extends Eloquent {

	protected $table = 'drivers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function team()
	{
		return $this->belongsTo('Team', 'team_id');
	}

	public function races()
	{
		return $this->belongsToMany('Race');
	}

	public function transmissionBox()
	{
		return $this->hasOne('TransmissionBox');
	}

}