<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('range_id')->unsigned();
			$table->bigInteger('type_id')->unsigned();
			$table->bigInteger('filling_id')->unsigned();
			$table->timestamps();
			$table->string('product_title');
			$table->string('product_description');
			$table->string('product_image');
			$table->smallInteger('ni_energy_kj');
			$table->smallInteger('ni_energy_kcal');
			$table->smallInteger('ni_fat');
			$table->smallInteger('ni_saturates');
			$table->smallInteger('ni_carbs');
			$table->smallInteger('ni_sugars');
			$table->smallInteger('ni_fibre');
			$table->smallInteger('ni_protein');
			$table->smallInteger('ni_salt');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}