<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreAccountTable extends Migration {

	public function up()
	{
		Schema::create('store_account', function(Blueprint $table) {
			$table->increments('id');
			$table->string('store_account_number');
			$table->string('store_name');
			$table->string('store_address_line1');
			$table->string('store_address_line2');
			$table->string('store_city');
			$table->string('store_post_code');
			$table->timestamps();
			$table->bigInteger('company_id')->unsigned();
			$table->bigInteger('product_scheme_id')->unsigned();
			$table->bigInteger('user_account_access_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('store_account');
	}
}