<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAxCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('ax_companies', function(Blueprint $table) {
			$table->timestamps();
			$table->string('company_id', 7)->primary();
			$table->string('name', 80);
			$table->integer('business_type');
			$table->integer('charter_capital')->nullable();
			$table->integer('number_employee')->nullable();
			$table->tinyInteger('is_stock_exchange')->nullable();
			$table->text('core_value')->nullable();
			$table->text('note');
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('ax_companies');
	}
}