<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->string('company_id', 7)->primary();
			$table->string('email')->unique();
			$table->string('password', 6)->nullable();
			$table->tinyInteger('first_login_flag')->default('0');
			$table->datetime('last_date_do_survey')->nullable();
			$table->tinyInteger('additional_flag')->nullable()->default('0');
			$table->string('sale_staff_id', 20);
			$table->string('company_name');
			$table->tinyInteger('business_type_id');
			$table->integer('charter_capital')->nullable();
			$table->integer('number_employee')->nullable();
			$table->tinyInteger('is_stock_exchange')->default('0');
			$table->text('core_value')->nullable();
			$table->text('note')->nullable();
			$table->timestamps();
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}