<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImprovementActivityScoresTable extends Migration {

	public function up()
	{
		Schema::create('improvement_activity_scores', function(Blueprint $table) {
			$table->string('company_id', 7)->primary();
			$table->integer('schedule_number')->primary();
			$table->tinyInteger('aggregated_unit_classify')->primary();
			$table->string('aggregated_unit_name', 200)->primary();
			$table->float('qc_survey_score', 5,2);
			$table->float('qc_survey_average_point', 5,2);
			$table->float('before_score', 5,2);
			$table->float('before_average_point', 5,2);
			$table->float('after_score', 5,2);
			$table->float('after_average_point', 5,2);
			$table->timestamps();
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('improvement_activity_scores');
	}
}