<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->timestamps();
			$table->string('question_code', 20)->primary();
			$table->string('question_subclass_code', 20);
			$table->string('evaluation_subclass_code', 20);
			$table->tinyInteger('survey_type');
			$table->string('qc_survey_question_code', 20)->nullable();
			$table->string('question_content', 200);
			$table->string('question_type', 20);
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}