<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSurveyAnswerStatesTable extends Migration {

	public function up()
	{
		Schema::create('survey_answer_states', function(Blueprint $table) {
			$table->string('company_id', 7)->primary();
			$table->integer('schedule_number')->primary();
			$table->tinyInteger('aggregated_unit_classify')->primary();
			$table->string('aggregated_unit_name', 200)->primary();
			$table->integer('total_send')->nullable();
			$table->integer('total_answer')->nullable();
			$table->timestamps();
			$table->float('answer_rate', 5,2)->nullable();
			$table->string('created_user');
			$table->string('updated_user')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('survey_answer_states');
	}
}